\name{TransformGeometryImageFilter}
\alias{TransformGeometryImageFilter}
\title{TransformGeometryImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Modify an image's geometric meta-data, changing its "physical"
extent.
TransformGeometryImageFilter}
\details{
The TransformGeometryImageFilter "physically" changes the image in space using the given
transformation. The resulting image is an image with the same voxel
values as the input, but with different physical space representation
as affected by the transform.
The specific transformation type can be any type derived from the MatrixOffsetTransformBase and the TranslationTransform . The modification of the geometric meta-data is an alternative to
resampling the moving image onto the fixed image grid, after
registration. The advantages of using this approach over resampling
are two-fold, it does not introduce artifacts into the result because
the original intensity information is not modified, and it is
computationally more efficient.
When the filter is used with a rigid or translation transformation the
resulting image can be saved in any desired format. When the filter is
used with an affine transformation the resulting image should be saved
in a format that supports a non ortho-normal direction cosine matrix
(e.g. nrrd).
Let us call the transform operation from the fixed image to moving
image TfmF2M . Given a set of points from the fixed image in physical
space (i.e. physicalFixedImagePoints ), the aim is to convert those
points into the moving image physical space as
physicalMovingImagePoints = TfmF2M( physicalFixedImagePoints ) , and
then be able to get the image values as movingContinuousIndexPoints =
movingImage->TransformPhysicalPointToContinuousIndex(
physicalMovingImagePoints ) .
We desire to change the moving image direction cosine \eqn{\mathbf{D}} and origin \eqn{\mathbf{o}} such that we can compute the moving image points as
movingContinuousIndexPoints =
newMovingImage->TransformPhysicalPointToContinuousIndex(
physicalFixedImagePoints )
Let us introduce the notation that will be used to formalize the
transformation:
Image-related parameters:
 \eqn{\mathbf{D}} : direction cosine matrix
 \eqn{\mathbf{o}} : origin vector
 \eqn{\mathbf{S}} : spacing
 \eqn{\mathbf{ci}} : continuous index
 \eqn{\mathbf{D}^{'}} : new direction cosine matrix
 \eqn{\mathbf{o}^{'}} : new origin vector
Image content in corresponding space:
 \eqn{\mathbf{f}_{p}} : fixed image points in physical space
 \eqn{\mathbf{m}_{p}} : moving image points in physical space
Rigid transform-related parameters:
 \eqn{\mathbf{R}} : rotation matrix
 \eqn{\mathbf{c}} : center of rotation vector
 \eqn{\mathbf{t}} : translation vector
 The TransformPhysicalPointToContinuousIndex method performs then:
\\\\begin{eqnarray*} \\\\mathbf{ci} &=
\\\\mathbf{S}^{-1}\\\\mathbf{D}^{-1}( \\\\mathbf{m}_{p} -
\\\\mathbf{o} ) \\\\ \\\\mathbf{m}_{p} &=
\\\\mathbf{R}(\\\\mathbf{f}_{p} - \\\\mathbf{c}) + \\\\mathbf{c} +
\\\\mathbf{t} \\\\end{eqnarray*}
After substitution:
\\\\begin{eqnarray*} \\\\mathbf{m}_{c} &=
\\\\underbrace{\\\\mathbf{R}^{-1}\\\\mathbf{D}}_\\\\text{new
cosine}\\\\mathbf{S} * \\\\mathbf{i} +
\\\\underbrace{\\\\mathbf{R}^{-1} * \\\\mathbf{o} - \\\\mathbf{R}^{-1}
* \\\\mathbf{c} - \\\\mathbf{R}^{-1}*t}_\\\\text{new origin} +
\\\\mathbf{c} \\\\ \\\\ \\\\mathbf{D}^{'} &=
\\\\mathbf{R}^{-1}\\\\mathbf{D} \\\\ \\\\mathbf{o}^{'} &=
\\\\mathbf{R}^{-1} * ( \\\\mathbf{o} - \\\\mathbf{c} - \\\\mathbf{t} )
+ \\\\mathbf{c} \\\\end{eqnarray*}
See:
TransformGeometry for the procedural interface
itk::TransformGeometryImageFilter for the Doxygen on the original ITK class.
TransformGeometryImageFilter}
%C++ includes: sitkTransformGeometryImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Transform &transform):}{}
\item{Image Execute(Image &&image, const Transform &transform):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ TransformGeometryImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~TransformGeometryImageFilter():}{
Destructor
}
}
}
