/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;

public abstract class SignificantTermsAggregateBase<TBucket>
extends MultiBucketAggregateBase<TBucket> {
    @Nullable
    private final Long bgCount;
    @Nullable
    private final Long docCount;

    protected SignificantTermsAggregateBase(AbstractBuilder<TBucket, ?> builder) {
        super(builder);
        this.bgCount = ((AbstractBuilder)builder).bgCount;
        this.docCount = ((AbstractBuilder)builder).docCount;
    }

    @Nullable
    public final Long bgCount() {
        return this.bgCount;
    }

    @Nullable
    public final Long docCount() {
        return this.docCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bgCount != null) {
            generator.writeKey("bg_count");
            generator.write(this.bgCount.longValue());
        }
        if (this.docCount != null) {
            generator.writeKey("doc_count");
            generator.write(this.docCount.longValue());
        }
    }

    protected static <TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>> void setupSignificantTermsAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TBucket> tBucketDeserializer) {
        SignificantTermsAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, tBucketDeserializer);
        op.add(AbstractBuilder::bgCount, JsonpDeserializer.longDeserializer(), "bg_count");
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.bgCount);
        result = 31 * result + Objects.hashCode(this.docCount);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignificantTermsAggregateBase other = (SignificantTermsAggregateBase)o;
        return Objects.equals(this.bgCount, other.bgCount) && Objects.equals(this.docCount, other.docCount);
    }

    public static abstract class AbstractBuilder<TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>>
    extends MultiBucketAggregateBase.AbstractBuilder<TBucket, BuilderT> {
        @Nullable
        private Long bgCount;
        @Nullable
        private Long docCount;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(SignificantTermsAggregateBase<TBucket> o) {
            super(o);
            this.bgCount = ((SignificantTermsAggregateBase)o).bgCount;
            this.docCount = ((SignificantTermsAggregateBase)o).docCount;
        }

        protected AbstractBuilder(AbstractBuilder<TBucket, BuilderT> o) {
            super(o);
            this.bgCount = o.bgCount;
            this.docCount = o.docCount;
        }

        @Nonnull
        public final BuilderT bgCount(@Nullable Long value) {
            this.bgCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT docCount(@Nullable Long value) {
            this.docCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

