﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ram/RAM_EXPORTS.h>
#include <aws/ram/model/ResourceSharePermissionDetail.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace RAM {
namespace Model {
class GetPermissionResult {
 public:
  AWS_RAM_API GetPermissionResult() = default;
  AWS_RAM_API GetPermissionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RAM_API GetPermissionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An object with details about the permission.</p>
   */
  inline const ResourceSharePermissionDetail& GetPermission() const { return m_permission; }
  template <typename PermissionT = ResourceSharePermissionDetail>
  void SetPermission(PermissionT&& value) {
    m_permissionHasBeenSet = true;
    m_permission = std::forward<PermissionT>(value);
  }
  template <typename PermissionT = ResourceSharePermissionDetail>
  GetPermissionResult& WithPermission(PermissionT&& value) {
    SetPermission(std::forward<PermissionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetPermissionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ResourceSharePermissionDetail m_permission;

  Aws::String m_requestId;
  bool m_permissionHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RAM
}  // namespace Aws
