/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import javax.annotation.CheckReturnValue;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.EmptyChildMap;
import org.gradle.internal.snapshot.VfsRelativePath;

public class VersionHierarchy {
    private final long version;
    private final long maxVersionInHierarchy;
    private final ChildMap<VersionHierarchy> children;

    public static VersionHierarchy empty(long version) {
        return new VersionHierarchy(EmptyChildMap.getInstance(), version, version);
    }

    private VersionHierarchy(ChildMap<VersionHierarchy> children, long version, long maxVersionInHierarchy) {
        this.children = children;
        this.version = version;
        this.maxVersionInHierarchy = maxVersionInHierarchy;
    }

    public long getVersion(VfsRelativePath relativePath, final CaseSensitivity caseSensitivity) {
        return this.children.withNode(relativePath, caseSensitivity, new ChildMap.NodeHandler<VersionHierarchy, Long>(){

            @Override
            public Long handleAsDescendantOfChild(VfsRelativePath pathInChild, VersionHierarchy child) {
                return child.getVersion(pathInChild, caseSensitivity);
            }

            @Override
            public Long handleAsAncestorOfChild(String childPath, VersionHierarchy child) {
                return child.getMaxVersionInHierarchy();
            }

            @Override
            public Long handleExactMatchWithChild(VersionHierarchy child) {
                return child.getMaxVersionInHierarchy();
            }

            @Override
            public Long handleUnrelatedToAnyChild() {
                return VersionHierarchy.this.version;
            }
        });
    }

    @CheckReturnValue
    public VersionHierarchy updateVersion(VfsRelativePath relativePath, final long newVersion, final CaseSensitivity caseSensitivity) {
        ChildMap<VersionHierarchy> newChildren = this.children.store(relativePath, caseSensitivity, new ChildMap.StoreHandler<VersionHierarchy>(){

            @Override
            public VersionHierarchy handleAsDescendantOfChild(VfsRelativePath pathInChild, VersionHierarchy child) {
                return child.updateVersion(pathInChild, newVersion, caseSensitivity);
            }

            @Override
            public VersionHierarchy handleAsAncestorOfChild(String childPath, VersionHierarchy child) {
                return this.createChild();
            }

            @Override
            public VersionHierarchy mergeWithExisting(VersionHierarchy child) {
                return this.createChild();
            }

            @Override
            public VersionHierarchy createChild() {
                return VersionHierarchy.empty(newVersion);
            }

            @Override
            public VersionHierarchy createNodeFromChildren(ChildMap<VersionHierarchy> children) {
                return new VersionHierarchy(children, VersionHierarchy.this.version, newVersion);
            }
        });
        return new VersionHierarchy(newChildren, this.version, newVersion);
    }

    public long getMaxVersionInHierarchy() {
        return this.maxVersionInHierarchy;
    }
}

