/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions.expression;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.Workflows;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParserBaseVisitor;

public class PredicateEvaluator
extends BooleanConditionParserBaseVisitor<Predicate> {
    private final CriteriaBuilder cb;
    private final CriteriaQuery<String> query;
    private final Root<?> root;
    private final KeycloakSession session;

    public PredicateEvaluator(KeycloakSession session, CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> root) {
        this.session = session;
        this.cb = cb;
        this.query = query;
        this.root = root;
    }

    @Override
    public Predicate visitEvaluator(BooleanConditionParser.EvaluatorContext ctx) {
        return (Predicate)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Predicate visitExpression(BooleanConditionParser.ExpressionContext ctx) {
        if (ctx.OR() != null) {
            Predicate left = (Predicate)this.visit((ParseTree)ctx.expression());
            Predicate right = (Predicate)this.visit((ParseTree)ctx.andExpression());
            return this.cb.or((Expression)left, (Expression)right);
        }
        return (Predicate)this.visit((ParseTree)ctx.andExpression());
    }

    @Override
    public Predicate visitAndExpression(BooleanConditionParser.AndExpressionContext ctx) {
        if (ctx.AND() != null) {
            Predicate left = (Predicate)this.visit((ParseTree)ctx.andExpression());
            Predicate right = (Predicate)this.visit((ParseTree)ctx.notExpression());
            return this.cb.and((Expression)left, (Expression)right);
        }
        return (Predicate)this.visit((ParseTree)ctx.notExpression());
    }

    @Override
    public Predicate visitNotExpression(BooleanConditionParser.NotExpressionContext ctx) {
        if (ctx.NOT() != null) {
            return this.cb.not((Expression)this.visit((ParseTree)ctx.notExpression()));
        }
        return (Predicate)this.visit((ParseTree)ctx.atom());
    }

    @Override
    public Predicate visitAtom(BooleanConditionParser.AtomContext ctx) {
        if (ctx.conditionCall() != null) {
            return (Predicate)this.visit((ParseTree)ctx.conditionCall());
        }
        return (Predicate)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Predicate visitConditionCall(BooleanConditionParser.ConditionCallContext ctx) {
        String conditionName = ctx.Identifier().getText();
        WorkflowConditionProvider conditionProvider = Workflows.getConditionProvider((KeycloakSession)this.session, (String)conditionName, (String)this.extractParameter(ctx.parameter()));
        return conditionProvider.toPredicate(this.cb, this.query, this.root);
    }

    protected String extractParameter(BooleanConditionParser.ParameterContext paramCtx) {
        if (paramCtx == null || paramCtx.ParameterText() == null) {
            return null;
        }
        String rawText = paramCtx.ParameterText().getText();
        return this.unEscapeParameter(rawText);
    }

    private String unEscapeParameter(String rawText) {
        return rawText.replace("\\)", ")").replace("\\\\", "\\");
    }
}

