/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseKt;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/daemon/report/CompileServicesFacadeMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;)V", "mySeverity", "", "hasErrors", "", "clear", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "kotlin-daemon"})
public final class CompileServicesFacadeMessageCollector
implements MessageCollector {
    @NotNull
    private final CompilerServicesFacadeBase servicesFacade;
    private final int mySeverity;
    private boolean hasErrors;

    public CompileServicesFacadeMessageCollector(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull CompilationOptions compilationOptions) {
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        this.servicesFacade = servicesFacade;
        this.mySeverity = compilationOptions.getReportSeverity();
    }

    public void clear() {
        this.hasErrors = false;
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        KotlinCompileDaemon.INSTANCE.getLog().info("Message: " + MessageRenderer.WITHOUT_PATHS.render(severity, message, location));
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 8: {
                CompilerServicesFacadeBaseKt.report$default(this.servicesFacade, ReportCategory.OUTPUT_MESSAGE, ReportSeverity.ERROR, message, null, 8, null);
                break;
            }
            case 6: {
                CompilerServicesFacadeBaseKt.report$default(this.servicesFacade, ReportCategory.EXCEPTION, ReportSeverity.ERROR, message, null, 8, null);
                break;
            }
            default: {
                ReportSeverity reportSeverity;
                switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        reportSeverity = ReportSeverity.ERROR;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        reportSeverity = ReportSeverity.WARNING;
                        break;
                    }
                    case 5: {
                        reportSeverity = ReportSeverity.INFO;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        reportSeverity = ReportSeverity.DEBUG;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ReportSeverity reportSeverity2 = reportSeverity;
                if (reportSeverity2.getCode() > this.mySeverity) break;
                CompilerServicesFacadeBaseKt.report(this.servicesFacade, ReportCategory.COMPILER_MESSAGE, reportSeverity2, message, (Serializable)location);
            }
        }
        this.hasErrors = this.hasErrors || severity.isError();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerMessageSeverity.values().length];
            try {
                nArray[CompilerMessageSeverity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.FIXED_WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.INFO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.LOGGING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.OUTPUT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

