/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;

public class LifecycleExecutionException
extends Exception {
    private MavenProject project;

    public LifecycleExecutionException(String message) {
        super(message);
    }

    public LifecycleExecutionException(Throwable cause) {
        super(cause);
    }

    public LifecycleExecutionException(String message, Throwable cause) {
        super(message, cause);
    }

    public LifecycleExecutionException(String message, MavenProject project) {
        super(message);
        this.project = project;
    }

    public LifecycleExecutionException(String message, MojoExecution execution, MavenProject project) {
        super(message);
        this.project = project;
    }

    public LifecycleExecutionException(String message, MojoExecution execution, MavenProject project, Throwable cause) {
        super(message, cause);
        this.project = project;
    }

    public LifecycleExecutionException(MojoExecution execution, MavenProject project, Throwable cause) {
        this(LifecycleExecutionException.createMessage(execution, project, cause), execution, project, cause);
    }

    public MavenProject getProject() {
        return this.project;
    }

    private static String createMessage(MojoExecution execution, MavenProject project, Throwable cause) {
        MessageBuilder buffer = MessageUtils.buffer((int)256);
        buffer.a((CharSequence)"Failed to execute goal");
        if (execution != null) {
            buffer.a((Object)Character.valueOf(' '));
            buffer.mojo((Object)(execution.getGroupId() + ':' + execution.getArtifactId() + ':' + execution.getVersion() + ':' + execution.getGoal()));
            buffer.a((Object)Character.valueOf(' ')).strong((Object)('(' + execution.getExecutionId() + ')'));
        }
        if (project != null) {
            buffer.a((CharSequence)" on project ");
            buffer.project((Object)project.getArtifactId());
        }
        if (cause != null) {
            buffer.a((CharSequence)": ").failure((Object)cause.getMessage());
        }
        return buffer.toString();
    }
}

