/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.file;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;

public abstract class AbstractBlockIndexInput
extends IndexInput
implements RandomAccessInput {
    private static final Logger logger = LogManager.getLogger(AbstractBlockIndexInput.class);
    public static final String CLEANER_THREAD_NAME_PREFIX = "index-input-cleaner";
    protected static final Cleaner CLEANER = Cleaner.create(OpenSearchExecutors.daemonThreadFactory("index-input-cleaner"));
    protected final long offset;
    protected final long length;
    protected final boolean isClone;
    protected final int blockSizeShift;
    protected final int blockSize;
    protected final int blockMask;
    protected int currentBlockId;
    private final BlockHolder blockHolder = new BlockHolder();
    protected final Cleaner.Cleanable cleanable;

    protected AbstractBlockIndexInput(Builder builder) {
        super(builder.resourceDescription);
        this.isClone = builder.isClone;
        this.offset = builder.offset;
        this.length = builder.length;
        this.blockSizeShift = builder.blockSizeShift;
        this.blockSize = builder.blockSize;
        this.blockMask = builder.blockMask;
        this.cleanable = CLEANER.register((Object)this, this.blockHolder);
    }

    protected abstract AbstractBlockIndexInput buildSlice(String var1, long var2, long var4);

    protected abstract IndexInput fetchBlock(int var1) throws IOException;

    public abstract AbstractBlockIndexInput clone();

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + String.valueOf((Object)this));
        }
        return this.buildSlice(sliceDescription, offset, length);
    }

    public void close() throws IOException {
        this.blockHolder.close();
        this.currentBlockId = 0;
    }

    public long getFilePointer() {
        if (this.blockHolder.block == null) {
            return 0L;
        }
        return this.currentBlockStart() + (long)this.currentBlockPosition() - this.offset;
    }

    public long length() {
        return this.length;
    }

    public byte readByte() throws IOException {
        if (this.blockHolder.block == null) {
            this.seek(0L);
        } else if (this.currentBlockPosition() >= this.blockSize) {
            int blockId = this.currentBlockId + 1;
            this.demandBlock(blockId);
        }
        return this.blockHolder.block.readByte();
    }

    public short readShort() throws IOException {
        if (this.blockHolder.block != null && 2 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readShort();
        }
        return super.readShort();
    }

    public int readInt() throws IOException {
        if (this.blockHolder.block != null && 4 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readInt();
        }
        return super.readInt();
    }

    public long readLong() throws IOException {
        if (this.blockHolder.block != null && 8 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readLong();
        }
        return super.readLong();
    }

    public final int readVInt() throws IOException {
        if (this.blockHolder.block != null && 5 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readVInt();
        }
        return super.readVInt();
    }

    public final long readVLong() throws IOException {
        if (this.blockHolder.block != null && 9 <= this.blockSize - this.currentBlockPosition()) {
            return this.blockHolder.block.readVLong();
        }
        return super.readVLong();
    }

    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + String.valueOf((Object)this));
        }
        this.seekInternal(pos + this.offset);
    }

    public final byte readByte(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset)) {
            return ((RandomAccessInput)this.blockHolder.block).readByte((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return this.blockHolder.block.readByte();
    }

    public short readShort(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset, 2)) {
            return ((RandomAccessInput)this.blockHolder.block).readShort((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readShort();
    }

    public int readInt(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset, 4)) {
            return ((RandomAccessInput)this.blockHolder.block).readInt((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readInt();
    }

    public long readLong(long pos) throws IOException {
        if (this.blockHolder.block != null && this.isInCurrentBlockRange(pos += this.offset, 8)) {
            return ((RandomAccessInput)this.blockHolder.block).readLong((long)this.getBlockOffset(pos));
        }
        this.seekInternal(pos);
        return super.readLong();
    }

    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        int available;
        if (this.blockHolder.block == null) {
            this.seek(0L);
        }
        if (len <= (available = this.blockSize - this.currentBlockPosition())) {
            this.blockHolder.block.readBytes(b, offset, len);
        } else {
            if (available > 0) {
                this.blockHolder.block.readBytes(b, offset, available);
                offset += available;
                len -= available;
            }
            while (len > 0) {
                int blockId = this.currentBlockId + 1;
                int toRead = Math.min(len, this.blockSize);
                this.demandBlock(blockId);
                this.blockHolder.block.readBytes(b, offset, toRead);
                offset += toRead;
                len -= toRead;
            }
        }
    }

    public static int getBlockSize(int blockSizeShift) {
        return 1 << blockSizeShift;
    }

    public static int getBlock(long pos, int blockSizeShift) {
        return (int)(pos >>> blockSizeShift);
    }

    public static long getBlockOffset(long pos, int blockSizeShift) {
        return pos & (long)(AbstractBlockIndexInput.getBlockSize(blockSizeShift) - 1);
    }

    public static long getBlockStart(int blockId, int blockSizeShift) {
        return (long)blockId << blockSizeShift;
    }

    public static int getNumberOfBlocks(long fileSize, int blockSizeShift) {
        return AbstractBlockIndexInput.getBlock(fileSize - 1L, blockSizeShift) + 1;
    }

    public static long getActualBlockSize(int blockId, int blockSizeShift, long fileSize) {
        assert (blockId >= 0) : "blockId cannot be negative";
        return blockId != AbstractBlockIndexInput.getBlock(fileSize - 1L, blockSizeShift) ? (long)AbstractBlockIndexInput.getBlockSize(blockSizeShift) : AbstractBlockIndexInput.getBlockOffset(fileSize - 1L, blockSizeShift) + 1L;
    }

    public static List<Integer> getAllBlockIdsForFile(long fileSize, int blockSizeShift) {
        return IntStream.rangeClosed(0, AbstractBlockIndexInput.getNumberOfBlocks(fileSize, blockSizeShift) - 1).boxed().collect(Collectors.toList());
    }

    public static boolean isBlockFilename(String fileName) {
        return fileName.contains("_block_");
    }

    public static String getBlockFileName(String fileName, int blockId) {
        return fileName + "_block_" + blockId;
    }

    public static String getFileNameFromBlockFileName(String blockFileName) {
        return blockFileName.contains("_block_") ? blockFileName.substring(0, blockFileName.indexOf("_block_")) : blockFileName;
    }

    private void seekInternal(long pos) throws IOException {
        if (this.blockHolder.block == null || !this.isInCurrentBlockRange(pos)) {
            this.demandBlock(this.getBlock(pos));
        }
        this.blockHolder.block.seek((long)this.getBlockOffset(pos));
    }

    private boolean isInCurrentBlockRange(long pos) {
        long offset = pos - this.currentBlockStart();
        return offset >= 0L && offset < (long)this.blockSize;
    }

    private boolean isInCurrentBlockRange(long pos, int len) {
        long offset = pos - this.currentBlockStart();
        return offset >= 0L && offset + (long)len <= (long)this.blockSize;
    }

    private void demandBlock(int blockId) throws IOException {
        if (this.blockHolder.block != null && this.currentBlockId == blockId) {
            return;
        }
        this.blockHolder.close();
        this.blockHolder.set(this.fetchBlock(blockId));
        this.currentBlockId = blockId;
    }

    protected void cloneBlock(AbstractBlockIndexInput other) {
        if (other.blockHolder.block != null) {
            this.blockHolder.set(other.blockHolder.block.clone());
            this.currentBlockId = other.currentBlockId;
        }
    }

    protected int getBlock(long pos) {
        return (int)(pos >>> this.blockSizeShift);
    }

    protected int getBlockOffset(long pos) {
        return (int)(pos & (long)this.blockMask);
    }

    protected long getBlockStart(int blockId) {
        return (long)blockId << this.blockSizeShift;
    }

    protected long currentBlockStart() {
        return this.getBlockStart(this.currentBlockId);
    }

    protected int currentBlockPosition() {
        return (int)this.blockHolder.block.getFilePointer();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        public static final int DEFAULT_BLOCK_SIZE_SHIFT = 23;
        public static final int DEFAULT_BLOCK_SIZE = 0x800000;
        protected String resourceDescription;
        protected boolean isClone;
        protected long offset;
        protected long length;
        protected int blockSizeShift = 23;
        protected int blockSize = 1 << this.blockSizeShift;
        protected int blockMask = this.blockSize - 1;

        protected Builder() {
        }

        protected final T self() {
            return (T)this;
        }

        public T resourceDescription(String resourceDescription) {
            this.resourceDescription = Objects.requireNonNull(resourceDescription, "Resource description cannot be null");
            return this.self();
        }

        public T isClone(boolean clone) {
            this.isClone = clone;
            return this.self();
        }

        public T offset(long offset) {
            this.offset = offset;
            return this.self();
        }

        public T length(long length) {
            this.length = length;
            return this.self();
        }

        public T blockSizeShift(int blockSizeShift) {
            assert (blockSizeShift < 31) : "blockSizeShift must be < 31";
            this.blockSizeShift = blockSizeShift;
            this.blockSize = 1 << blockSizeShift;
            this.blockMask = this.blockSize - 1;
            return this.self();
        }
    }

    private static class BlockHolder
    implements Closeable,
    Runnable {
        private volatile IndexInput block;

        private BlockHolder() {
        }

        private void set(IndexInput block) {
            if (this.block != null) {
                throw new IllegalStateException("Previous block was not closed!");
            }
            this.block = Objects.requireNonNull(block);
        }

        @Override
        public void close() throws IOException {
            if (this.block != null) {
                this.block.close();
                this.block = null;
            }
        }

        @Override
        public void run() {
            try {
                this.close();
            }
            catch (IOException e) {
                logger.info("Exception thrown while closing block owned by phantom reachable instance", (Throwable)e);
            }
        }
    }
}

