/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityBlockResourceState;
import software.amazon.awssdk.services.ec2.model.CapacityReservationIdSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityBlock> {
    private static final SdkField<String> CAPACITY_BLOCK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityBlockId").getter(CapacityBlock.getter(CapacityBlock::capacityBlockId)).setter(CapacityBlock.setter(Builder::capacityBlockId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockId").unmarshallLocationName("capacityBlockId").build()}).build();
    private static final SdkField<String> ULTRASERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UltraserverType").getter(CapacityBlock.getter(CapacityBlock::ultraserverType)).setter(CapacityBlock.setter(Builder::ultraserverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraserverType").unmarshallLocationName("ultraserverType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CapacityBlock.getter(CapacityBlock::availabilityZone)).setter(CapacityBlock.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CapacityBlock.getter(CapacityBlock::availabilityZoneId)).setter(CapacityBlock.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<List<String>> CAPACITY_RESERVATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservationIds").getter(CapacityBlock.getter(CapacityBlock::capacityReservationIds)).setter(CapacityBlock.setter(Builder::capacityReservationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationIdSet").unmarshallLocationName("capacityReservationIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(CapacityBlock.getter(CapacityBlock::startDate)).setter(CapacityBlock.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").unmarshallLocationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(CapacityBlock.getter(CapacityBlock::endDate)).setter(CapacityBlock.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("endDate").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(CapacityBlock.getter(CapacityBlock::createDate)).setter(CapacityBlock.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").unmarshallLocationName("createDate").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CapacityBlock.getter(CapacityBlock::stateAsString)).setter(CapacityBlock.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CapacityBlock.getter(CapacityBlock::tags)).setter(CapacityBlock.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_ID_FIELD, ULTRASERVER_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CAPACITY_RESERVATION_IDS_FIELD, START_DATE_FIELD, END_DATE_FIELD, CREATE_DATE_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityBlockId;
    private final String ultraserverType;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final List<String> capacityReservationIds;
    private final Instant startDate;
    private final Instant endDate;
    private final Instant createDate;
    private final String state;
    private final List<Tag> tags;

    private CapacityBlock(BuilderImpl builder) {
        this.capacityBlockId = builder.capacityBlockId;
        this.ultraserverType = builder.ultraserverType;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.capacityReservationIds = builder.capacityReservationIds;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.createDate = builder.createDate;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String capacityBlockId() {
        return this.capacityBlockId;
    }

    public final String ultraserverType() {
        return this.ultraserverType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final boolean hasCapacityReservationIds() {
        return this.capacityReservationIds != null && !(this.capacityReservationIds instanceof SdkAutoConstructList);
    }

    public final List<String> capacityReservationIds() {
        return this.capacityReservationIds;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final CapacityBlockResourceState state() {
        return CapacityBlockResourceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraserverType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservationIds() ? this.capacityReservationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityBlock)) {
            return false;
        }
        CapacityBlock other = (CapacityBlock)obj;
        return Objects.equals(this.capacityBlockId(), other.capacityBlockId()) && Objects.equals(this.ultraserverType(), other.ultraserverType()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && this.hasCapacityReservationIds() == other.hasCapacityReservationIds() && Objects.equals(this.capacityReservationIds(), other.capacityReservationIds()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityBlock").add("CapacityBlockId", (Object)this.capacityBlockId()).add("UltraserverType", (Object)this.ultraserverType()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("CapacityReservationIds", this.hasCapacityReservationIds() ? this.capacityReservationIds() : null).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("CreateDate", (Object)this.createDate()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockId": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockId()));
            }
            case "UltraserverType": {
                return Optional.ofNullable(clazz.cast(this.ultraserverType()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "CapacityReservationIds": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationIds()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockId", CAPACITY_BLOCK_ID_FIELD);
        map.put("UltraserverType", ULTRASERVER_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("CapacityReservationIdSet", CAPACITY_RESERVATION_IDS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityBlock, T> g) {
        return obj -> g.apply((CapacityBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityBlockId;
        private String ultraserverType;
        private String availabilityZone;
        private String availabilityZoneId;
        private List<String> capacityReservationIds = DefaultSdkAutoConstructList.getInstance();
        private Instant startDate;
        private Instant endDate;
        private Instant createDate;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityBlock model) {
            this.capacityBlockId(model.capacityBlockId);
            this.ultraserverType(model.ultraserverType);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.capacityReservationIds(model.capacityReservationIds);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.createDate(model.createDate);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getCapacityBlockId() {
            return this.capacityBlockId;
        }

        public final void setCapacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
        }

        @Override
        public final Builder capacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
            return this;
        }

        public final String getUltraserverType() {
            return this.ultraserverType;
        }

        public final void setUltraserverType(String ultraserverType) {
            this.ultraserverType = ultraserverType;
        }

        @Override
        public final Builder ultraserverType(String ultraserverType) {
            this.ultraserverType = ultraserverType;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Collection<String> getCapacityReservationIds() {
            if (this.capacityReservationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityReservationIds;
        }

        public final void setCapacityReservationIds(Collection<String> capacityReservationIds) {
            this.capacityReservationIds = CapacityReservationIdSetCopier.copy(capacityReservationIds);
        }

        @Override
        public final Builder capacityReservationIds(Collection<String> capacityReservationIds) {
            this.capacityReservationIds = CapacityReservationIdSetCopier.copy(capacityReservationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationIds(String ... capacityReservationIds) {
            this.capacityReservationIds(Arrays.asList(capacityReservationIds));
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityBlockResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CapacityBlock build() {
            return new CapacityBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityBlock> {
        public Builder capacityBlockId(String var1);

        public Builder ultraserverType(String var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder capacityReservationIds(Collection<String> var1);

        public Builder capacityReservationIds(String ... var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder createDate(Instant var1);

        public Builder state(String var1);

        public Builder state(CapacityBlockResourceState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

