/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc;

public class GetSecurityGroupsForVpcPublisher
implements SdkPublisher<GetSecurityGroupsForVpcResponse> {
    private final Ec2AsyncClient client;
    private final GetSecurityGroupsForVpcRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSecurityGroupsForVpcPublisher(Ec2AsyncClient client, GetSecurityGroupsForVpcRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSecurityGroupsForVpcPublisher(Ec2AsyncClient client, GetSecurityGroupsForVpcRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSecurityGroupsForVpcResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSecurityGroupsForVpcResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityGroupForVpc> securityGroupForVpcs() {
        Function<GetSecurityGroupsForVpcResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroupForVpcs() != null) {
                return response.securityGroupForVpcs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSecurityGroupsForVpcResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSecurityGroupsForVpcResponseFetcher
    implements AsyncPageFetcher<GetSecurityGroupsForVpcResponse> {
        private GetSecurityGroupsForVpcResponseFetcher() {
        }

        public boolean hasNextPage(GetSecurityGroupsForVpcResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSecurityGroupsForVpcResponse> nextPage(GetSecurityGroupsForVpcResponse previousPage) {
            if (previousPage == null) {
                return GetSecurityGroupsForVpcPublisher.this.client.getSecurityGroupsForVpc(GetSecurityGroupsForVpcPublisher.this.firstRequest);
            }
            return GetSecurityGroupsForVpcPublisher.this.client.getSecurityGroupsForVpc((GetSecurityGroupsForVpcRequest)((Object)GetSecurityGroupsForVpcPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

