/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.snapshot;

import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.indexmanagement.indexstatemanagement.action.SnapshotAction;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.step.snapshot.AttemptSnapshotStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;
import org.opensearch.snapshots.ConcurrentSnapshotExecutionException;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.ClusterAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\n\u0010\u001a\u001a\u00060\u001dj\u0002`\u001eH\u0002J(\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/snapshot/AttemptSnapshotStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/SnapshotAction;", "<init>", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/SnapshotAction;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "info", "", "", "", "snapshotName", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDenied", "", "denyList", "", "repoName", "handleSnapshotException", "", "indexName", "e", "Lorg/opensearch/snapshots/ConcurrentSnapshotExecutionException;", "handleException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "compileTemplate", "template", "Lorg/opensearch/script/Script;", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "defaultValue", "scriptService", "Lorg/opensearch/script/ScriptService;", "getUpdatedManagedIndexMetadata", "currentMetadata", "isIdempotent", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nAttemptSnapshotStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttemptSnapshotStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/snapshot/AttemptSnapshotStep\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,179:1\n488#2,7:180\n*S KotlinDebug\n*F\n+ 1 AttemptSnapshotStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/snapshot/AttemptSnapshotStep\n*L\n143#1:180,7\n*E\n"})
public final class AttemptSnapshotStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SnapshotAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @Nullable
    private String snapshotName;
    @NotNull
    private static final Set<String> validTopContextFields;
    @NotNull
    public static final String name = "attempt_snapshot";

    public AttemptSnapshotStep(@NotNull SnapshotAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, 2, null);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var17_2 = $completion;
        if ((var17_2.label & -2147483648) != 0) {
            var17_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptSnapshotStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                managedIndexMetadata = context.getMetadata();
                scriptService = context.getScriptService();
                v1 = context.getClusterService().getClusterSettings().get(ManagedIndexSettings.Companion.getSNAPSHOT_DENY_LIST());
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                denyList = (List)v1;
                repository = this.action.getRepository();
                snapshot = this.action.getSnapshot();
                mutableInfo = new LinkedHashMap<K, V>();
                if (this.isDenied(denyList, repository)) {
                    this.stepStatus = Step.StepStatus.FAILED;
                    mutableInfo.put("message", AttemptSnapshotStep.Companion.getBlockedMessage(denyList, repository, indexName));
                    this.info = MapsKt.toMap((Map)mutableInfo);
                    return this;
                }
                snapshotNameSuffix = "-" + LocalDateTime.now(ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern("uuuu.MM.dd-HH:mm:ss.SSS", Locale.ROOT));
                snapshotScript = new Script(ScriptType.INLINE, "mustache", snapshot, MapsKt.emptyMap());
                defaultSnapshotName = StringsKt.isBlank((CharSequence)snapshot) != false ? snapshot : indexName;
                this.snapshotName = this.compileTemplate(snapshotScript, managedIndexMetadata, defaultSnapshotName, scriptService) + snapshotNameSuffix;
                var14_28 = new String[]{indexName};
                createSnapshotRequest = new CreateSnapshotRequest().userMetadata(MapsKt.mapOf((Pair)TuplesKt.to((Object)"snapshot_created", (Object)"Open Distro for Elasticsearch Index Management"))).indices(var14_28).includeGlobalState(false).snapshot(this.snapshotName).repository(repository).waitForCompletion(false);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$1 = indexName;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)managedIndexMetadata);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)scriptService);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)denyList);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)repository);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)snapshot);
                $continuation.L$7 = mutableInfo;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)snapshotNameSuffix);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)snapshotScript);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)defaultSnapshotName);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)createSnapshotRequest);
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().cluster(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, execute$lambda$0(org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest org.opensearch.transport.client.ClusterAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/ClusterAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((CreateSnapshotRequest)createSnapshotRequest), $continuation);
                ** if (v2 != var18_4) goto lbl55
lbl54:
                // 1 sources

                return var18_4;
lbl55:
                // 1 sources

                ** GOTO lbl73
            }
            case 1: {
                createSnapshotRequest = (CreateSnapshotRequest)$continuation.L$11;
                defaultSnapshotName = (String)$continuation.L$10;
                snapshotScript = (Script)$continuation.L$9;
                snapshotNameSuffix = (String)$continuation.L$8;
                mutableInfo = (Map)$continuation.L$7;
                snapshot = (String)$continuation.L$6;
                repository = (String)$continuation.L$5;
                denyList = (List)$continuation.L$4;
                scriptService = (ScriptService)$continuation.L$3;
                managedIndexMetadata = (ManagedIndexMetaData)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                context = (StepContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl73:
                    // 2 sources

                    response = (CreateSnapshotResponse)v2;
                    v3 = response.status();
                    switch (v3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v3.ordinal()]) {
                        case 1: {
                            this.stepStatus = Step.StepStatus.COMPLETED;
                            mutableInfo.put("message", AttemptSnapshotStep.Companion.getSuccessMessage(indexName));
                            break;
                        }
                        case 2: {
                            this.stepStatus = Step.StepStatus.COMPLETED;
                            mutableInfo.put("message", AttemptSnapshotStep.Companion.getSuccessMessage(indexName));
                            break;
                        }
                        default: {
                            message = AttemptSnapshotStep.Companion.getFailedMessage(indexName);
                            this.logger.warn(message + " - " + response);
                            this.stepStatus = Step.StepStatus.FAILED;
                            mutableInfo.put("message", AttemptSnapshotStep.Companion.getFailedMessage(indexName));
                            mutableInfo.put("cause", response.toString());
                        }
                    }
                    this.info = MapsKt.toMap((Map)mutableInfo);
                }
                catch (RemoteTransportException e) {
                    cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof ConcurrentSnapshotExecutionException) {
                        this.handleSnapshotException(indexName, (ConcurrentSnapshotExecutionException)cause);
                    } else {
                        Intrinsics.checkNotNull((Object)cause, (String)"null cannot be cast to non-null type java.lang.Exception");
                        this.handleException(indexName, (Exception)cause);
                    }
                }
                catch (ConcurrentSnapshotExecutionException e) {
                    this.handleSnapshotException(indexName, e);
                }
                catch (Exception e) {
                    this.handleException(indexName, e);
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isDenied(List<String> denyList, String repoName) {
        Function1 predicate = arg_0 -> AttemptSnapshotStep.isDenied$lambda$1(repoName, arg_0);
        return denyList.stream().anyMatch(arg_0 -> AttemptSnapshotStep.isDenied$lambda$2(predicate, arg_0));
    }

    private final void handleSnapshotException(String indexName, ConcurrentSnapshotExecutionException e) {
        String message = Companion.getFailedConcurrentSnapshotMessage(indexName);
        this.logger.debug(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
    }

    private final void handleException(String indexName, Exception e) {
        String message = Companion.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    private final String compileTemplate(Script template, ManagedIndexMetaData managedIndexMetaData, String defaultValue, ScriptService scriptService) {
        Map<String, Object> $this$filterKeys$iv = OpenSearchExtensionsKt.convertToMap((ToXContent)managedIndexMetaData);
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, Object> result$iv = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry$iv : $this$filterKeys$iv.entrySet()) {
            String key = entry$iv.getKey();
            boolean bl = false;
            if (!validTopContextFields.contains(key)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map contextMap = result$iv;
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT);
        Map map = template.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParams(...)");
        String compiledValue = factory.newInstance(MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", (Object)contextMap)))).execute();
        Intrinsics.checkNotNull((Object)compiledValue);
        return StringsKt.isBlank((CharSequence)compiledValue) ? defaultValue : compiledValue;
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData;
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData = currentActionMetaData = currentMetadata.getActionMetaData();
        ActionMetaData actionMetaData2 = actionMetaData != null ? ActionMetaData.copy$default((ActionMetaData)actionMetaData, null, null, (int)0, (boolean)false, (int)0, null, (ActionProperties)new ActionProperties(null, this.snapshotName, null, null, null, null, 61, null), (int)63, null) : null;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData2, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    public boolean isIdempotent() {
        return false;
    }

    private static final Unit execute$lambda$0(CreateSnapshotRequest $createSnapshotRequest, ClusterAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.createSnapshot($createSnapshotRequest, it);
        return Unit.INSTANCE;
    }

    private static final boolean isDenied$lambda$1(String $repoName, String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return Regex.simpleMatch((String)pattern, (String)$repoName);
    }

    private static final boolean isDenied$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"index", "indexUuid"};
        validTopContextFields = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/snapshot/AttemptSnapshotStep$Companion;", "", "<init>", "()V", "validTopContextFields", "", "", "getValidTopContextFields", "()Ljava/util/Set;", "name", "getBlockedMessage", "denyList", "", "repoName", "index", "getFailedMessage", "getFailedConcurrentSnapshotMessage", "getSuccessMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getValidTopContextFields() {
            return validTopContextFields;
        }

        @NotNull
        public final String getBlockedMessage(@NotNull List<String> denyList, @NotNull String repoName, @NotNull String index2) {
            Intrinsics.checkNotNullParameter(denyList, (String)"denyList");
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Snapshot repository [" + repoName + "] is blocked in " + denyList + " [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to create snapshot [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedConcurrentSnapshotMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Concurrent snapshot in progress, retrying next execution [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully started snapshot [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestStatus.values().length];
            try {
                nArray[RestStatus.ACCEPTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestStatus.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

