/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.neuralsearch.common.MinClusterVersionUtil;
import org.opensearch.neuralsearch.query.NeuralQueryBuilder;
import org.opensearch.neuralsearch.query.dto.NeuralQueryBuildStage;
import org.opensearch.neuralsearch.query.dto.NeuralQueryTargetFieldConfig;

public class NeuralQueryValidationUtil {
    public static List<String> validateNeuralQueryForKnn(@NonNull NeuralQueryBuilder queryBuilder, NeuralQueryBuildStage buildStage) {
        Objects.requireNonNull(queryBuilder, "queryBuilder is marked non-null but is null");
        List<String> errors = NeuralQueryValidationUtil.validateNeuralQueryForDenseCommonRules(queryBuilder);
        if (NeuralQueryValidationUtil.isModelIdRequiredForNeuralQueryForKnn(buildStage) && queryBuilder.modelId() == null) {
            errors.add(String.format(Locale.ROOT, "%s must be provided.", NeuralQueryBuilder.MODEL_ID_FIELD.getPreferredName()));
        }
        if (queryBuilder.searchAnalyzer() != null) {
            errors.add(String.format(Locale.ROOT, "Target field is a KNN field using a dense model. %s is not supported since it is for the sparse model.", NeuralQueryBuilder.SEMANTIC_FIELD_SEARCH_ANALYZER_FIELD.getPreferredName()));
        }
        if (queryBuilder.queryTokensMapSupplier() != null) {
            errors.add(String.format(Locale.ROOT, "Target field is a KNN field using a dense model. %s is not supported since it is for the sparse model.", NeuralQueryBuilder.QUERY_TOKENS_FIELD.getPreferredName()));
        }
        return errors;
    }

    private static boolean isModelIdRequiredForNeuralQueryForKnn(NeuralQueryBuildStage buildStage) {
        if (NeuralQueryBuildStage.REWRITE.equals((Object)buildStage)) {
            return true;
        }
        boolean isBuiltFromXContent = buildStage == null || NeuralQueryBuildStage.FROM_X_CONTENT.equals((Object)buildStage);
        boolean supportsDefaultModel = MinClusterVersionUtil.isClusterOnOrAfterMinReqVersionForDefaultDenseModelIdSupport();
        return isBuiltFromXContent && !supportsDefaultModel;
    }

    private static int countKnnQueryTypes(NeuralQueryBuilder queryBuilder) {
        int counter = 0;
        if (queryBuilder.k() != null) {
            ++counter;
        }
        if (queryBuilder.maxDistance() != null) {
            ++counter;
        }
        if (queryBuilder.minScore() != null) {
            ++counter;
        }
        return counter;
    }

    public static List<String> validateNeuralQueryForSemanticDense(@NonNull NeuralQueryBuilder queryBuilder) {
        Objects.requireNonNull(queryBuilder, "queryBuilder is marked non-null but is null");
        List<String> errors = NeuralQueryValidationUtil.validateNeuralQueryForDenseCommonRules(queryBuilder);
        if (queryBuilder.queryTokensMapSupplier() != null) {
            errors.add(String.format(Locale.ROOT, "Target field is a semantic field using a dense model. %s is not supported since it is for the sparse model.", NeuralQueryBuilder.QUERY_TOKENS_FIELD.getPreferredName()));
        }
        if (queryBuilder.searchAnalyzer() != null) {
            errors.add(String.format(Locale.ROOT, "Target field is a semantic field using a dense model. %s is not supported since it is for the sparse model.", NeuralQueryBuilder.SEMANTIC_FIELD_SEARCH_ANALYZER_FIELD.getPreferredName()));
        }
        return errors;
    }

    private static List<String> validateNeuralQueryForDenseCommonRules(@NonNull NeuralQueryBuilder queryBuilder) {
        int knnQueryTypes;
        Objects.requireNonNull(queryBuilder, "queryBuilder is marked non-null but is null");
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)queryBuilder.queryText()) && StringUtils.isBlank((CharSequence)queryBuilder.queryImage())) {
            errors.add(String.format(Locale.ROOT, "Either %s or %s must be provided.", NeuralQueryBuilder.QUERY_TEXT_FIELD.getPreferredName(), NeuralQueryBuilder.QUERY_IMAGE_FIELD.getPreferredName()));
        }
        if ((knnQueryTypes = NeuralQueryValidationUtil.countKnnQueryTypes(queryBuilder)) > 1) {
            errors.add(String.format(Locale.ROOT, "Only one of %s, %s, or %s can be provided", KNNQueryBuilder.K_FIELD.getPreferredName(), KNNQueryBuilder.MAX_DISTANCE_FIELD.getPreferredName(), KNNQueryBuilder.MIN_SCORE_FIELD.getPreferredName()));
        } else if (knnQueryTypes == 0) {
            queryBuilder.k(10);
        }
        if ("".equals(queryBuilder.modelId())) {
            errors.add(String.format(Locale.ROOT, "%s field can not be empty", NeuralQueryBuilder.MODEL_ID_FIELD.getPreferredName()));
        }
        return errors;
    }

    public static List<String> validateNeuralQueryForSemanticSparse(@NonNull NeuralQueryBuilder queryBuilder) {
        Set<String> fieldsOnlySupportedByDenseModel;
        Objects.requireNonNull(queryBuilder, "queryBuilder is marked non-null but is null");
        ArrayList<String> errors = new ArrayList<String>();
        if (queryBuilder.queryTokensMapSupplier() == null && queryBuilder.queryText() == null) {
            errors.add(String.format(Locale.ROOT, "Either %s or %s must be provided", NeuralQueryBuilder.QUERY_TEXT_FIELD.getPreferredName(), NeuralQueryBuilder.QUERY_TOKENS_FIELD.getPreferredName()));
        } else if (queryBuilder.queryTokensMapSupplier() == null && "".equals(queryBuilder.queryText())) {
            errors.add(String.format(Locale.ROOT, "%s field can not be empty", NeuralQueryBuilder.QUERY_TEXT_FIELD.getPreferredName()));
        }
        int countValidInputsForSemanticSparseQuery = 0;
        if (queryBuilder.modelId() != null) {
            ++countValidInputsForSemanticSparseQuery;
        }
        if (queryBuilder.searchAnalyzer() != null) {
            ++countValidInputsForSemanticSparseQuery;
        }
        if (queryBuilder.queryTokensMapSupplier() != null) {
            ++countValidInputsForSemanticSparseQuery;
        }
        if (countValidInputsForSemanticSparseQuery > 1) {
            errors.add(String.format(Locale.ROOT, "%s, %s and %s can not coexist", NeuralQueryBuilder.QUERY_TOKENS_FIELD.getPreferredName(), NeuralQueryBuilder.MODEL_ID_FIELD.getPreferredName(), NeuralQueryBuilder.SEMANTIC_FIELD_SEARCH_ANALYZER_FIELD.getPreferredName()));
        }
        if ("".equals(queryBuilder.modelId())) {
            errors.add(String.format(Locale.ROOT, "%s field can not be empty", NeuralQueryBuilder.MODEL_ID_FIELD.getPreferredName()));
        }
        if ("".equals(queryBuilder.searchAnalyzer())) {
            errors.add(String.format(Locale.ROOT, "%s field can not be empty", NeuralQueryBuilder.SEMANTIC_FIELD_SEARCH_ANALYZER_FIELD.getPreferredName()));
        }
        if (!(fieldsOnlySupportedByDenseModel = NeuralQueryValidationUtil.getFieldsOnlySupportedByDenseModel(queryBuilder)).isEmpty()) {
            errors.add(String.format(Locale.ROOT, "Target field is a semantic field using a sparse model. [%s] are not supported since they are for the dense model.", String.join((CharSequence)", ", fieldsOnlySupportedByDenseModel)));
        }
        return errors;
    }

    private static Set<String> getFieldsOnlySupportedByDenseModel(NeuralQueryBuilder queryBuilder) {
        HashSet<String> fieldsOnlySupportedByDenseModel = new HashSet<String>();
        if (queryBuilder.queryImage() != null) {
            fieldsOnlySupportedByDenseModel.add(NeuralQueryBuilder.QUERY_IMAGE_FIELD.getPreferredName());
        }
        if (queryBuilder.k() != null) {
            fieldsOnlySupportedByDenseModel.add(KNNQueryBuilder.K_FIELD.getPreferredName());
        }
        if (queryBuilder.maxDistance() != null) {
            fieldsOnlySupportedByDenseModel.add(KNNQueryBuilder.MAX_DISTANCE_FIELD.getPreferredName());
        }
        if (queryBuilder.minScore() != null) {
            fieldsOnlySupportedByDenseModel.add(KNNQueryBuilder.MIN_SCORE_FIELD.getPreferredName());
        }
        if (queryBuilder.expandNested() != null) {
            fieldsOnlySupportedByDenseModel.add(KNNQueryBuilder.EXPAND_NESTED_FIELD.getPreferredName());
        }
        if (queryBuilder.queryfilter() != null) {
            fieldsOnlySupportedByDenseModel.add(KNNQueryBuilder.FILTER_FIELD.getPreferredName());
        }
        if (queryBuilder.methodParameters() != null) {
            fieldsOnlySupportedByDenseModel.add(KNNQueryBuilder.METHOD_PARAMS_FIELD.getPreferredName());
        }
        if (queryBuilder.rescoreContext() != null) {
            fieldsOnlySupportedByDenseModel.add(KNNQueryBuilder.RESCORE_FIELD.getPreferredName());
        }
        return fieldsOnlySupportedByDenseModel;
    }

    public static void validateTargetFieldConfig(@NonNull String fieldName, @NonNull Map<String, NeuralQueryTargetFieldConfig> indexToTargetFieldConfigMap) {
        Objects.requireNonNull(fieldName, "fieldName is marked non-null but is null");
        Objects.requireNonNull(indexToTargetFieldConfigMap, "indexToTargetFieldConfigMap is marked non-null but is null");
        ArrayList<String> indicesWithSemantic = new ArrayList<String>();
        ArrayList<String> indicesWithNonSemantic = new ArrayList<String>();
        ArrayList<String> indicesWithSemanticDense = new ArrayList<String>();
        ArrayList<String> indicesWithSemanticSparse = new ArrayList<String>();
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (Map.Entry<String, NeuralQueryTargetFieldConfig> entry : indexToTargetFieldConfigMap.entrySet()) {
            String targetIndex = entry.getKey();
            NeuralQueryTargetFieldConfig targetFieldConfig = entry.getValue();
            if (targetFieldConfig.getIsUnmappedField().booleanValue()) continue;
            if (targetFieldConfig.getIsSemanticField().booleanValue()) {
                indicesWithSemantic.add(targetIndex);
                switch (targetFieldConfig.getEmbeddingFieldType()) {
                    case "knn_vector": {
                        indicesWithSemanticDense.add(targetIndex);
                        break;
                    }
                    case "rank_features": {
                        indicesWithSemanticSparse.add(targetIndex);
                        break;
                    }
                    default: {
                        validationErrors.add(String.format(Locale.ROOT, "Unsupported embedding field type [%s] in the target index [%s]", targetFieldConfig.getEmbeddingFieldType(), targetIndex));
                        break;
                    }
                }
                continue;
            }
            indicesWithNonSemantic.add(targetIndex);
        }
        if (!indicesWithSemantic.isEmpty() && !indicesWithNonSemantic.isEmpty()) {
            validationErrors.add(String.format(Locale.ROOT, "The target field should be either a semantic field or a non-semantic field in all the target indices. It is a semantic field in the indices: %s while not a semantic field in the indices %s.", String.join((CharSequence)", ", indicesWithSemantic), String.join((CharSequence)", ", indicesWithNonSemantic)));
        } else if (!(indicesWithSemantic.isEmpty() || indicesWithSemanticDense.isEmpty() || indicesWithSemanticSparse.isEmpty())) {
            validationErrors.add(String.format(Locale.ROOT, "The target semantic field should be either use a dense model or a sparse model in all the target indices. It is a dense model in the indices: %s while a sparse model in the indices: %s", String.join((CharSequence)", ", indicesWithSemanticDense), String.join((CharSequence)", ", indicesWithSemanticSparse)));
        }
        if (!validationErrors.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid neural query against the field %s. Errors: %s", fieldName, String.join((CharSequence)"; ", validationErrors)));
        }
    }
}

