/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import java.time.Month;
import java.time.format.TextStyle;
import java.util.Locale;
import net.sourceforge.plantuml.StringUtils;

public class MonthUtils {
    public static String getRegexString() {
        StringBuilder sb = new StringBuilder();
        for (Month month : Month.values()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(month.name().substring(0, 3) + "[a-z]*");
        }
        return sb.toString();
    }

    public static Month fromString(String value) {
        value = StringUtils.goUpperCase(value).substring(0, 3);
        for (Month m : Month.values()) {
            if (!m.name().startsWith(value)) continue;
            return m;
        }
        throw new IllegalArgumentException();
    }

    public static String shortName(Month month, Locale locale) {
        if (locale == Locale.ENGLISH) {
            return StringUtils.capitalize(month.name()).substring(0, 3);
        }
        return StringUtils.capitalize(month.getDisplayName(TextStyle.SHORT_STANDALONE, locale));
    }

    public static String longName(Month month, Locale locale) {
        if (locale == Locale.ENGLISH) {
            return StringUtils.capitalize(month.name());
        }
        return month.getDisplayName(TextStyle.FULL_STANDALONE, locale);
    }
}

