"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const documents_1 = require("../../../src/lib/documents");
describe('DocumentMapper', () => {
    describe('FragmentMapper', () => {
        function setup(content, start, end) {
            return new documents_1.FragmentMapper(content, {
                start,
                end,
                endPos: (0, documents_1.positionAt)(end, content),
                content: content.substring(start, end)
            }, 'file:///hello.svelte');
        }
        it('isInGenerated works', () => {
            const fragment = setup('Hello, \nworld!', 8, 13);
            assert.strictEqual(fragment.isInGenerated({ line: 0, character: 0 }), false);
            assert.strictEqual(fragment.isInGenerated({ line: 1, character: 0 }), true);
            assert.strictEqual(fragment.isInGenerated({ line: 1, character: 5 }), true);
            assert.strictEqual(fragment.isInGenerated({ line: 1, character: 6 }), false);
        });
        it('calculates the position in parent', () => {
            const fragment = setup('Hello, \nworld!', 8, 13);
            assert.deepStrictEqual(fragment.getOriginalPosition({ line: 0, character: 2 }), {
                line: 1,
                character: 2
            });
        });
        it('calculates the position in fragment', () => {
            const fragment = setup('Hello, \nworld!', 8, 13);
            assert.deepStrictEqual(fragment.getGeneratedPosition({ line: 1, character: 2 }), {
                line: 0,
                character: 2
            });
        });
    });
});
//# sourceMappingURL=DocumentMapper.test.js.map