/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import javax.naming.NamingException;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;

public class PojoMessageHandlerWholeText
extends PojoMessageHandlerWholeBase<String> {
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeText.class);
    private final Class<?> primitiveType;

    public PojoMessageHandlerWholeText(Object object, Method method, Session session, EndpointConfig endpointConfig, List<Class<? extends Decoder>> list, Object[] objectArray, int n, boolean bl, int n2, long l) {
        super(object, method, session, objectArray, n, bl, n2, l);
        Class<?> clazz;
        if (l > -1L && l > (long)session.getMaxTextMessageBufferSize()) {
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(sm.getString("pojoMessageHandlerWhole.maxBufferSize"));
            }
            session.setMaxTextMessageBufferSize((int)l);
        }
        if (Util.isPrimitive(clazz = method.getParameterTypes()[n])) {
            this.primitiveType = clazz;
            return;
        }
        this.primitiveType = null;
        try {
            if (list != null) {
                for (Class<? extends Decoder> clazz2 : list) {
                    Decoder.Text text;
                    if (Decoder.Text.class.isAssignableFrom(clazz2)) {
                        text = (Decoder.Text)this.createDecoderInstance(clazz2);
                        text.init(endpointConfig);
                        this.decoders.add(text);
                        continue;
                    }
                    if (!Decoder.TextStream.class.isAssignableFrom(clazz2)) continue;
                    text = (Decoder.TextStream)this.createDecoderInstance(clazz2);
                    text.init(endpointConfig);
                    this.decoders.add(text);
                }
            }
        }
        catch (ReflectiveOperationException | NamingException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    protected Object decode(String string) throws DecodeException {
        if (this.primitiveType != null) {
            return Util.coerceToType(this.primitiveType, string);
        }
        for (Decoder decoder : this.decoders) {
            if (decoder instanceof Decoder.Text) {
                if (!((Decoder.Text)decoder).willDecode(string)) continue;
                return ((Decoder.Text)decoder).decode(string);
            }
            StringReader stringReader = new StringReader(string);
            try {
                return ((Decoder.TextStream)decoder).decode((Reader)stringReader);
            }
            catch (IOException iOException) {
                throw new DecodeException(string, sm.getString("pojoMessageHandlerWhole.decodeIoFail"), (Throwable)iOException);
            }
        }
        return null;
    }

    @Override
    protected Object convert(String string) {
        return new StringReader(string);
    }
}

